const {delay} = require("../helpers/helpers");
require('dotenv').config(); // Loads variables from .env into process.env
async function getUserNameById(browser, id) {
    try {
        const page = await browser.newPage();
        await page.goto('https://www.midasbuy.com/midasbuy/ot/redeem/pubgm', {timeout: 99999999});
        await page.type('[placeholder="Please enter your Player ID"]', id);
        await page.evaluate(() => {
            const input = document.querySelector('[placeholder="Please enter your Player ID"]');
            const parentElement = input.parentElement.parentElement;
            const btn = parentElement.querySelector('.btn');
            btn.click();
        });
        await page.waitForResponse('https://www.midasbuy.com/interface/getCharac');
        await delay(1000);
        const error = await page.$('.box > .error-tips');
        if (error) {
            return null;
        }
        const name =  await page.evaluate(() => {
            return document.querySelector('.user-head > .name').textContent;
        });
        await page.close();
        return name;
    } catch (e) {
        throw new Error(e);
    }
}
module.exports = getUserNameById;


